
Type TWrapper

	Field geom:TGeom
	Field shouldAddNode:Int
	Field minf:Float
	Field maxf:Float
	
	Field _xBegin:TStub
	Field _xEnd:TStub
	Field _yBegin:TStub
	Field _yEnd:TStub
	
	Function Create:TWrapper(body:TGeom) 
		Local w:TWrapper = New TWrapper
		w.geom = body

		w._xBegin = TStub.Create(w, True) 
		w._xEnd = TStub.Create(w, False) 
		w._yBegin = TStub.Create(w, True) 
		w._yEnd = TStub.Create(w, False) 
		Return w
	End Function
	
	Method AddStubs(xStubs:TStub[] Var, yStubs:TStub[] Var)
		xStubs = xStubs[..xStubs.Length + 2]
		xStubs[xStubs.length - 2] = _xBegin
		xStubs[xStubs.length - 1] = _xEnd
		
		'xStubs.AddLast(_xBegin)
		'xStubs.AddLast(_xEnd) 
		
		yStubs = yStubs[..yStubs.Length + 2]
		yStubs[yStubs.Length - 2] = _yBegin
		yStubs[yStubs.Length - 1] = _yBegin
		
		'yStubs.AddLast(_yBegin) 
		'yStubs.AddLast(_yEnd) 
	End Method
	
	Method Update() 
		Local rect:TAABB = geom._aabb 
		' if it is a single point in space
		' then don't even add it to the link list
		shouldAddNode = (rect._min.X <> rect._max.X) Or (rect._min.Y <> rect._max.Y) 
		
		_xBegin.value = rect._min.X
		_xEnd.value = rect._max.X
		
		_yBegin.value = rect._min.Y
		_yEnd.value = rect._max.Y
	End Method
	
	Method SetX() 
		minf = _xBegin.value
		maxf = _xEnd.value
	End Method
	
	Method SetY() 
		minf = _yBegin.value
		maxf = _yEnd.value	
	End Method
End Type
